<?php
/**
 * Plugin Name: Phone Blacklist (Basic)
 * Plugin URI:  https://astartemedia.gr/phone-blacklist-basic
 * Description: Simple phone-based blacklist for WooCommerce. Block orders at checkout when the billing phone number is in your blacklist.
 * Version:     1.0.0
 * Author:      Astarte Media & Labs
 * Author URI:  https://astartemedia.gr
 * License:     GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: phone-blacklist-basic
 * Requires PHP: 7.4
 * Requires at least: 5.8
 * Tested up to: 6.9
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'WPB_BLACKLIST_BASIC_VERSION', '1.0.0' );
define( 'WPB_BLACKLIST_BASIC_PATH', plugin_dir_path( __FILE__ ) );
define( 'WPB_BLACKLIST_BASIC_URL', plugin_dir_url( __FILE__ ) );
define( 'WPB_BLACKLIST_BASIC_BASENAME', plugin_basename( __FILE__ ) );

register_activation_hook( __FILE__, 'wpb_blacklist_basic_activation_check' );
function wpb_blacklist_basic_activation_check() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        wp_die(
            esc_html__( 'Phone Blacklist (Basic) requires WooCommerce to be active.', 'phone-blacklist-basic' )
        );
    }
}

// Core class.
require_once WPB_BLACKLIST_BASIC_PATH . 'includes/class-wpb-blacklist-basic.php';

add_action( 'plugins_loaded', 'wpb_blacklist_basic_init' );
function wpb_blacklist_basic_init() {
    if ( class_exists( 'WooCommerce' ) ) {
        new WPB_Blacklist_Basic();
    }
}
